/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.link;

import com.ibm.hwmca.base.custinfo.CustomerInfoData;
import com.ibm.hwmca.base.custinfo.CustomerInfoManager;
import com.ibm.hwmca.fw.rcs.PathManager;
import com.ibm.hwmca.fw.rcs.RcsConfig;
import com.ibm.hwmca.fw.rcs.RcsControl;
import com.ibm.hwmca.fw.rcs.conndata.ConnectionInfoManager;
import com.ibm.hwmca.fw.rcs.conndata.ConnectivityInfo;
import com.ibm.hwmca.fw.rcs.conndata.ServerInfo;
import com.ibm.hwmca.fw.rcs.link.LinkFailedException;
import com.ibm.hwmca.fw.rcs.link.LinkNotConfiguredException;
import com.ibm.hwmca.fw.rcs.link.RcsLink;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigData;
import com.ibm.hwmca.fw.rcs.outconn.OutboundConfigManager;
import com.ibm.hwmca.fw.util.Trace;

public class TestL2tpAttLink
extends RcsLink {
    private static final String TRACE_MASKT = "XRCSLALT";
    private static final String TRACE_MASKF = "XRCSLALF";
    private static final String TRACE_MASKD = "XRCSLALD";
    private static TestL2tpAttLink instance;
    private boolean active = false;

    protected TestL2tpAttLink() {
        super(1);
        Trace.trace(TRACE_MASKT, "<-> L2tpAttLink()");
    }

    public static RcsLink getInstance() {
        if (instance == null) {
            instance = new TestL2tpAttLink();
        }
        Trace.trace(TRACE_MASKT, "<-> getInstance() [" + instance + "]");
        return instance;
    }

    public boolean activate() throws LinkFailedException, LinkNotConfiguredException {
        Trace.trace(TRACE_MASKT, "--> activate()");
        if (this.active) {
            return true;
        }
        if (!this.isConfigured()) {
            throw new LinkNotConfiguredException();
        }
        try {
            int rc = 0;
            OutboundConfigData outConfig = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
            rc = RcsControl.startRemDial();
            if (rc != 0) {
                this.active = false;
                throw new LinkFailedException("Failed to remote dial (RC: " + rc + ")");
            }
            for (int sdc = 1; sdc <= 2; ++sdc) {
                PathManager.getPathManager().setSdc(sdc);
                CustomerInfoData custData = CustomerInfoManager.getCustomerInfoManager().getCustomerInfo();
                String country = custData.getSystemCountryCode();
                String region = custData.getSystemSubdivisionCode();
                ConnectivityInfo connData = ConnectionInfoManager.getConnectionInfoManager().getConnectivityInfo(country, region);
                ServerInfo serverInfo = connData.getServerInfo("Server_VPN");
                String vpnServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                serverInfo = connData.getServerInfo("Server_RS3");
                String rs3Server = serverInfo == null ? "" : serverInfo.getIpAddress();
                String rs3Port = serverInfo == null ? "" : String.valueOf(serverInfo.getPort());
                serverInfo = connData.getServerInfo("Server_SA");
                String sdrServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                serverInfo = connData.getServerInfo("Server_SAS");
                String sasServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                serverInfo = connData.getServerInfo("Server_URSF");
                String ursfServer = serverInfo == null ? "" : serverInfo.getIpAddress();
                RcsConfig cfg = RcsConfig.getRcsConfig();
                cfg.setTemporaryConfigValue("vpn_server", vpnServer);
                cfg.setTemporaryConfigValue("host_rs3", rs3Server);
                cfg.setTemporaryConfigValue("port_rs3", rs3Port);
                cfg.setTemporaryConfigValue("host_sdr", sdrServer);
                cfg.setTemporaryConfigValue("host_sas", sasServer);
                cfg.setTemporaryConfigValue("host_ursf", ursfServer);
                rc = RcsControl.startVpn();
                if (rc == 0) {
                    this.active = true;
                    break;
                }
                RcsControl.stopRemDial();
            }
            if (!this.active) {
                throw new LinkFailedException("Failed to start VPN (RC: " + rc + ")");
            }
        }
        catch (LinkFailedException e) {
            throw e;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- activate()");
        return true;
    }

    public void deactivate() {
        Trace.trace(TRACE_MASKT, "--> deactivate()");
        try {
            RcsControl.stopVpn();
            RcsControl.stopRemDial();
            this.active = false;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "Exception: " + e);
        }
        Trace.trace(TRACE_MASKT, "<-- deactivate()");
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isConfigured() {
        OutboundConfigData data = OutboundConfigManager.getOutboundConfigManager().getOutboundConfig();
        boolean configured = true;
        Trace.trace(TRACE_MASKT, "<-> isConfigured() [" + configured + "]");
        return configured;
    }
}

